/****************************************************************************

    FILEDLG.CPP        Version 1.00 / September 1993



    FUNCTION:    FileDlg()

    PURPOSE:     Provides a file dialog


    PARAMETERS:  CWnd*       Pointer to parent window
                 BOOL        TRUE        Open
                             FALSE       Save As
                 char*       Caption
                 char*       Filters
                 char*       Default file extension
                 long        Flags
                 char*       String to hold the resulting file name
                 char*       String to hold the resulting fully qualified
                             file name - this string MUST be
                             properly \0 terminated for SaveAs otherwise
                             the dialog will fail
                 UINT        Help id (0 if none)

    RETURNS:     BOOL        TRUE        Ok button pressed
                             FALSE       Cancel button pressed

    NOTES:       The Help id parameter must have had the value
                 HID_BASE_RESOURCE (defined in afxpriv.h) subtracted from it
                 when it is passed to this function because the MFC code adds
                 it back in in order to get the help page to call help with.
                 This means that help ids must be bigger than
                 HID_BASE_RESOURCE (ie 131072 decimal) but not too big to
                 cause the subtraction to give a value bigger than that which
                 a UINT can hold.

****************************************************************************/



// Include files
#include "stdafx.h"
#include <afxdlgs.h>
#include <afxpriv.h>



BOOL FileDlg(CWnd* ptpWnd, BOOL bpOpen,
             char *szpCaption, char *szpFilters, char *szpDefExt,
             long lpFlags,
             char *szpFileName, char *szpFullName,
             UINT ipHelpID) {

    BOOL         blRc;
    char szlFileName[81],
         szlFullName[81];


    // Save the names and use these in the dialog since we don't
    // want to change our parameters

    lstrcpy((LPSTR)szlFileName, (LPSTR)szpFileName);
    lstrcpy((LPSTR)szlFullName, (LPSTR)szpFullName);

    szlFileName[0] = 0;                // Clear out file name
    if(bpOpen) szlFullName[0] = 0;     // On open, don't prompt with file


    CFileDialog tlFile(bpOpen, (LPSTR)szpDefExt, (LPSTR)szlFullName,
                       lpFlags, (LPSTR)szpFilters, ptpWnd);
    tlFile.m_ofn.lpstrTitle = szpCaption;

    tlFile.SetHelpID(ipHelpID);


    blRc = tlFile.DoModal();
    if(blRc == IDOK) {
        // Extract the fully qualified and unqualified file names
        
        CString tlFullName(tlFile.GetPathName());
        
        CString tlFileName;
        tlFileName = tlFile.GetFileName() + "." + tlFile.GetFileExt();
        
        lstrcpy((LPSTR)szpFullName, tlFullName);
        lstrcpy((LPSTR)szpFileName, tlFileName);
    }
    
    return (blRc == IDOK ? TRUE : FALSE);
}
